import org.serviio.library.metadata.*
import org.serviio.library.online.*

/** AnOriant.info content URL extractor plugin.
 *
 * http://anoriant.info/tv/?feed=rss2
 *
 * @author Illico
 *
 * Version 1.1
 *
 */
class AnOriant extends FeedItemUrlExtractor {

	final VALID_FEED_URL = '^http://anoriant.info/.*'

	String getExtractorName() {
		return getClass().getName();
	}

	boolean extractorMatches(URL feedUrl) {
		return feedUrl ==~ VALID_FEED_URL;
	}

	/* Quality is ignored on AnOriant */
	ContentURLContainer extractUrl(Map links, PreferredQuality requestedQuality) {
		def linkUrl = links.alternate != null ? links.alternate : links.default
		// open the HTML page first		
		def webPage = linkUrl.getText()
		// find SWFObject : content file location 
		def matcher = webPage =~ "so.addVariable\\('file','(.*?)'\\)"
		assert matcher != null , 'Cette page ne contient pas de videos'
		println " contentUrl : " + matcher[0][1].toString()
		def matcher1 = webPage =~ '<div id="singlethumbnail">[\\r\\n]*.*<img src="(.*.jpg?)&.*"'
		assert matcher1 != null , 'Cette page ne contient pas de vignettes'
		println " thumbnailUrl : " + matcher1[0][1].toString()
		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: matcher[0][1].toString(), thumbnailUrl: matcher1[0][1].toString())
	}

	/* Groovy test method */
	static void main(args) {
		AnOriant extractor = new AnOriant()
		
		Map videoLinks = ['default': new URL("http://anoriant.info/tv/?p=856")]

		println "Name : " + extractor.getExtractorName();
		println "TestMatch : " + extractor.extractorMatches( new URL("http://anoriant.info/tv/?feed=rss2"));
		println "**** HIGH ****";extractor.extractUrl(videoLinks, PreferredQuality.HIGH);
		println "**** MEDIUM ****";extractor.extractUrl(videoLinks, PreferredQuality.MEDIUM);
		println "**** LOW ****";extractor.extractUrl(videoLinks, PreferredQuality.LOW);	
	}
}